#include "CorsairAgent.h"
#include "PFManager.h"
#include "AgentManager.h"

CorsairAgent::CorsairAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("CorsairAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
	lastUseFrame = Broodwar->getFrameCount();
}

void CorsairAgent::computeActions() {
	if (chargeShields()) {
		return;
	}

	if (Broodwar->getFrameCount() - lastUseFrame >= 80) {
		TechType web = TechTypes::Disruption_Web;
		if (Broodwar->self()->hasResearched(web)) {
			if (unit->getEnergy() >= 125) {
				Unit* target = getClosestEnemyAirDefense(320);
				if (target != NULL) {
					if (target->getEnsnareTimer() == 0) {
						unit->useTech(web, target);
						lastUseFrame = Broodwar->getFrameCount();
						//Broodwar->printf("[%d] Using Disruption Web on %s", unitID, target->getType().getName().c_str());
						return;
					}
				}
			}
		}
	}

	PFManager::getInstance()->computeAttackingUnitActions(this, goal, false);
}

string CorsairAgent::getTypeName() {
	return "CorsairAgent";
}
