#ifndef __CHOKEHARASSSQUAD_H__
#define __CHOKEHARASSSQUAD_H__

#include "BaseAgent.h"
#include "Squad.h"

using namespace BWAPI;
using namespace BWTA;
using namespace std;

/** This squad locates a chokepoint around the enemy base and guards it to prevent the
 * enemy from expanding. 
 *
 * Author: Johan Hagelback (johan.hagelback@gmail.com)
 */
class ChokeHarassSquad : public Squad {

private:
	
public:
	/** Constructor. See Squad.h for more details. */
	ChokeHarassSquad(int mId, string mName, int mMoveType, int mPriority);

	/** Returns true if this Squad is active, or false if not.
	 * A Squad is active when it first has been filled with agents.
	 * A Squad with destroyed units are still considered Active. */
	bool isActive();

	/** Called each update to issue orders. */
	void computeActions();

	/** Sets the goal for this Squad. */
	void setGoal(TilePosition mGoal);

	/** Clears the goal for this Squad, i.e. sets the goal
	 * to TilePosition(-1,-1). */
	void clearGoal();

	/** Returns the current goal of this Squad. */
	TilePosition getGoal();

	/** Returns true if this squad has an assigned goal. */
	bool hasGoal();

	/** Prints some info about the squad. */
	void printInfo();
};

#endif