#ifndef __BUNKERAGENT_H__
#define __BUNKERAGENT_H__

#include <BWAPI.h>
#include "StructureAgent.h"
using namespace BWAPI;
using namespace std;

/** The BunkerAgent handles Terran Bunker buildings.
 *
 * Implemented abilities:
 * - Keeps track of the units inside the bunker.
 * - Which units to use in the Bunker depends on the enemy race(s).
 *
 * Author: Johan Hagelback (johan.hagelback@gmail.com)
 */
class BunkerAgent : public StructureAgent {

private:
	void checkStimTrick(BaseAgent* agent);

public:
	vector<BaseAgent*> loadedUnits;

	/** Constructor. */
	BunkerAgent(Unit* mUnit);

	/** Destructor. */
	~BunkerAgent();

	/** Called each update to issue orders. */
	void computeActions();

	/** Returns the unique type name for structure agents. */
	string getTypeName();

	/** Used to print info about this agent to the screen. */
	void printInfo();
};

#endif