#include "BunkerAgent.h"
#include "MarineAgent.h"
#include "FirebatAgent.h"
#include "ExplorationManager.h"
#include "AgentManager.h"
#include "Commander.h"
#include "Squad.h"

BunkerAgent::BunkerAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("BunkerAgent created (%s)", unit->getType().getName().c_str());

	Commander::getInstance()->addBunkerSquad();
}

BunkerAgent::~BunkerAgent() {
	
}

void BunkerAgent::computeActions() {
	//Stim Pack trick
	if ((int)loadedUnits.size() > 0) {
		if (Broodwar->self()->hasResearched(TechTypes::Stim_Packs))  {
			for (int i = 0; i < (int)loadedUnits.size(); i++) {
				BaseAgent* agent = loadedUnits.at(i);
				if (isAlive() && agent->isAlive()) {
					checkStimTrick(agent);
				}
			}
		}
	}

	if (!unit->isBeingConstructed()) {
		if ((int)loadedUnits.size() < 4) {
			vector<Squad*> squads = Commander::getInstance()->getSquads();
			for (int i = 0; i < (int)squads.size(); i++) {
				//Look up the squads that are assigned to bunker defence
				if (squads.at(i)->isBunkerDefend()) {
					vector<BaseAgent*> agents = squads.at(i)->getMembers();
					//and load each member into a bunker (if not already in one)
					for (int a = 0; a < (int)agents.size(); a++) {
						BaseAgent* agent = agents.at(a);
						if (agent->isAlive() && agent->isOfType(UnitTypes::Terran_Marine)) {
							MarineAgent* marine = (MarineAgent*)agent;
							if (!marine->isBunkered()) {
								//Broodwar->printf("Assign Marine %d to bunker", marine->getUnitID());
								marine->assignToBunkerDefend(unit);
								loadedUnits.push_back(marine);
							}
						}
						if (agent->isAlive() && agent->isOfType(UnitTypes::Terran_Firebat)) {
							FirebatAgent* firebat = (FirebatAgent*)agent;
							if (!firebat->isBunkered()) {
								//Broodwar->printf("Assign Firebat %d to bunker", marine->getUnitID());
								firebat->assignToBunkerDefend(unit);
								loadedUnits.push_back(firebat);
							}
						}
					}
				}
			}
		}
	}
}

void BunkerAgent::checkStimTrick(BaseAgent* agent) {
	UnitAgent* cAgent = (UnitAgent*)agent;
	UnitType type = cAgent->getUnitType();
	if (cAgent->enemyAttackingUnitsWithinRange(6 * 32, unit->getTilePosition()) > 0) {
		//We are being attacked.
		Unit* soldier = cAgent->getUnit();

		if (soldier->isLoaded() && !soldier->isStimmed()) {
			//1. Unload all units
			unit->unloadAll();
			return;
		}
		if (!soldier->isLoaded() && !soldier->isStimmed()) {
			//2. Use Stim Packs
			//Broodwar->printf("Bunkered agent %s using Stim Packs", type.getName().c_str());
			soldier->useTech(TechTypes::Stim_Packs);
			return;
		}
		if (!soldier->isLoaded() && soldier->isStimmed()) {
			//Broodwar->printf("Bunkered agent %s re-entering Bunker", type.getName().c_str());
			//3. Enter Bunker again
			soldier->rightClick(unit);
			return;
		}
	}
}

string BunkerAgent::getTypeName() {
	return "BunkerAgent";
}

void BunkerAgent::printInfo() {
	Broodwar->printf("[%d] (%s) with %d loaded agents", unitID, getTypeName().c_str(), (int)loadedUnits.size());
}
