#include "BuildOrderFileReader.h"
#include "ExplorationManager.h"
#include "BuildPlanner.h"
#include <fstream>
#include <sstream>

bool BuildOrderFileReader::fileExists(string filename) {
	ifstream inFile;

	stringstream ss;
	ss << "bwapi-data\\AI\\BTHAI-data\\buildorder\\";
	ss << filename;
	string filePath = ss.str();

	inFile.open(filePath.c_str());

	if (!inFile) {
		return false;
	}
	else {
		inFile.close();
		return true;
	}
}

string BuildOrderFileReader::getFilename() {
	string filename = "";

	if (BuildPlanner::isProtoss()) {
		if (ExplorationManager::enemyIsProtoss()) {
			filename = "PvP.txt";
			if (!fileExists(filename)) filename = "PvX.txt";
		}
		else if (ExplorationManager::enemyIsTerran()) {
			filename = "PvT.txt";
			if (!fileExists(filename)) filename = "PvX.txt";
		}
		else if (ExplorationManager::enemyIsZerg()) {
			filename = "PvZ.txt";
			if (!fileExists(filename)) filename = "PvX.txt";
		}
	}
	else if (BuildPlanner::isTerran()) {
		if (ExplorationManager::enemyIsProtoss()) {
			filename = "TvP.txt";
			if (!fileExists(filename)) filename = "TvX.txt";
		}
		else if (ExplorationManager::enemyIsTerran()) {
			filename = "TvT.txt";
			if (!fileExists(filename)) filename = "TvX.txt";
		}
		else if (ExplorationManager::enemyIsZerg()) {
			filename = "TvZ.txt";
			if (!fileExists(filename)) filename = "TvX.txt";
		}
	}
	else if (BuildPlanner::isZerg()) {
		if (ExplorationManager::enemyIsProtoss()) {
			filename = "ZvP.txt";
			if (!fileExists(filename)) filename = "ZvX.txt";
		}
		else if (ExplorationManager::enemyIsTerran()) {
			filename = "ZvT.txt";
			if (!fileExists(filename)) filename = "ZvX.txt";
		}
		else if (ExplorationManager::enemyIsZerg()) {
			filename = "ZvZ.txt";
			if (!fileExists(filename)) filename = "ZvX.txt";
		}
	}

	return filename;
}

vector<UnitType> BuildOrderFileReader::readBuildOrder() {
	string filename = getFilename();
	vector<UnitType> buildOrder;

	//Read buildorder file
	ifstream inFile;

	stringstream ss;
	ss << "bwapi-data\\AI\\BTHAI-data\\buildorder\\";
	ss << filename;
	string filePath = ss.str();

	inFile.open(filePath.c_str());

	if (!inFile) {
		Broodwar->printf("Unable to open file %s", filePath.c_str());
	}
	else {
		string line;
		char buffer[256];
		while (!inFile.eof()) {
			inFile.getline(buffer, 100);
			if (buffer[0] != ';') {
				stringstream ss;
				ss << buffer;
				line = ss.str();
				addUnitType(line, buildOrder);
			}
		}
		inFile.close();
	}

	Broodwar->printf("Build order file %s loaded", filePath.c_str());

	return buildOrder;
}

void BuildOrderFileReader::addUnitType(string line, vector<UnitType> &buildOrder) {
	if (line == "") return;

	//Replace all _ with whitespaces, or they wont match
	replace(line);
	
	for(set<UnitType>::iterator i=UnitTypes::allUnitTypes().begin();i!=UnitTypes::allUnitTypes().end();i++) {
		if ((*i).getName() == line) {
			buildOrder.push_back((*i));
			return;
		}
	}

	//No UnitType match found
	Broodwar->printf("Error: No matching UnitType found for %s", line.c_str());
}

void BuildOrderFileReader::replace(string &line) {
	int usIndex = line.find("_");
	while (usIndex != string::npos) {
		line.replace(usIndex, 1, " ");
		usIndex = line.find("_");
	}
}
