#include "BattlecruiserAgent.h"
#include "PFManager.h"
#include "AgentManager.h"

BattlecruiserAgent::BattlecruiserAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("BattlecruiserAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
	lastUseFrame = Broodwar->getFrameCount();
}

void BattlecruiserAgent::computeActions() {
	if (Broodwar->getFrameCount() - lastUseFrame >= 80) {
		TechType gun = TechTypes::Yamato_Gun;
		if (Broodwar->self()->hasResearched(gun)) {
			if (unit->getEnergy() >= gun.energyUsed()) {
				int range = gun.getWeapon().maxRange();
				Unit* enemy = getClosestEnemyTurret(range);
				if (enemy != NULL) {
					//Broodwar->printf("[%d] Yamato Gun used", unitID);
					unit->useTech(gun, enemy);
					lastUseFrame = Broodwar->getFrameCount();
					return;
				}
			}
		}
	}

	PFManager::getInstance()->computeAttackingUnitActions(this, goal, false);
}

string BattlecruiserAgent::getTypeName() {
	return "BattlecruiserAgent";
}
